#include <linux/types.h>
#include <linux/delay.h>
#include <asm/io.h>

#include <linux/version.h>
#include <asm/uaccess.h>

#include "linux/video_decoder.h"
#include "zr36120.h"

extern unsigned int swapi2c;   /* tell the driver to swap SDA/SCL */

/* ----------------------------------------------------------------------- */
/* I2C functions							   */
/* ----------------------------------------------------------------------- */

/* software I2C functions */

#define I2C_DELAY   10

static void i2c_setlines(struct i2c_bus *bus,int ctrl,int data)
{
	struct zoran *ztv = (struct zoran*)bus->data;
	unsigned int b = 0;
	if (data) b |= swapi2c ? ZORAN_I2C_SCL : ZORAN_I2C_SDA;
	if (ctrl) b |= swapi2c ? ZORAN_I2C_SDA : ZORAN_I2C_SCL;
	zrwrite(b, ZORAN_I2C);
	udelay(I2C_DELAY);
}

static int i2c_getdataline(struct i2c_bus *bus)
{
	struct zoran *ztv = (struct zoran*)bus->data;
	if (swapi2c)
		return zrread(ZORAN_I2C) & ZORAN_I2C_SCL;
	return zrread(ZORAN_I2C) & ZORAN_I2C_SDA;
}

static
void attach_inform(struct i2c_bus *bus, int id)
{
	struct zoran *ztv = (struct zoran*)bus->data;

	switch (id) {
	 case I2C_DRIVERID_DECODER:
		ztv->have_decoder = 1;
		DEBUG(printk(KERN_INFO "%s: decoder attached\n",CARD));
		break;
	 default:
		DEBUG(printk(KERN_INFO "%s: attach_inform; unknown device id=%d\n",CARD,id));
		break;
	}
}

static
void detach_inform(struct i2c_bus *bus, int id)
{
	struct zoran *ztv = (struct zoran*)bus->data;

	switch (id) {
	 case I2C_DRIVERID_DECODER:
		ztv->have_decoder = 0;
		DEBUG(printk(KERN_INFO "%s: decoder detached\n",CARD));
		break;
	 default:
		DEBUG(printk(KERN_INFO "%s: detach_inform; unknown device id=%d\n",CARD,id));
		break;
	}
}

struct i2c_bus zoran_i2c_bus_template =
{
	"ZR36120",
	I2C_BUSID_ZORAN,
	NULL,

	SPIN_LOCK_UNLOCKED,

	attach_inform,
	detach_inform,

	i2c_setlines,
	i2c_getdataline,
	NULL,
	NULL
};
